/* THIS FILE IS AUTOGENERATED FROM TrackEvent.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_TrackEventBinding_h
#define mozilla_dom_TrackEventBinding_h

#include "EventBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class AudioTrack;
struct NativePropertyHooks;
class OwningVideoTrackOrAudioTrackOrTextTrack;
class ProtoAndIfaceCache;
class TextTrack;
class TrackEvent;
struct TrackEventInitAtoms;
class VideoTrack;
class VideoTrackOrAudioTrackOrTextTrack;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningVideoTrackOrAudioTrackOrTextTrack& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningVideoTrackOrAudioTrackOrTextTrack& aUnion);


class VideoTrackOrAudioTrackOrTextTrack
{
  enum TypeOrUninit
  {
    eUninitialized,
    eVideoTrack,
    eAudioTrack,
    eTextTrack
  };
public:
  enum class Type
  {
    eVideoTrack = TypeOrUninit::eVideoTrack,
    eAudioTrack = TypeOrUninit::eAudioTrack,
    eTextTrack = TypeOrUninit::eTextTrack
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::VideoTrack> > mVideoTrack;
    UnionMember<NonNull<mozilla::dom::AudioTrack> > mAudioTrack;
    UnionMember<NonNull<mozilla::dom::TextTrack> > mTextTrack;

  };

  TypeOrUninit mType;
  Value mValue;

  VideoTrackOrAudioTrackOrTextTrack(const VideoTrackOrAudioTrackOrTextTrack&) = delete;
  VideoTrackOrAudioTrackOrTextTrack& operator=(const VideoTrackOrAudioTrackOrTextTrack&) = delete;
public:
  explicit inline VideoTrackOrAudioTrackOrTextTrack()
    : mType(eUninitialized)
  {
  }

  inline ~VideoTrackOrAudioTrackOrTextTrack()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::VideoTrack>&
  RawSetAsVideoTrack()
  {
    if (mType == eVideoTrack) {
      return mValue.mVideoTrack.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eVideoTrack;
    return mValue.mVideoTrack.SetValue();
  }

  inline NonNull<mozilla::dom::VideoTrack>&
  SetAsVideoTrack()
  {
    if (mType == eVideoTrack) {
      return mValue.mVideoTrack.Value();
    }
    Uninit();
    mType = eVideoTrack;
    return mValue.mVideoTrack.SetValue();
  }

  inline bool
  IsVideoTrack() const
  {
    return mType == eVideoTrack;
  }

  inline NonNull<mozilla::dom::VideoTrack>&
  GetAsVideoTrack()
  {
    MOZ_RELEASE_ASSERT(IsVideoTrack(), "Wrong type!");
    return mValue.mVideoTrack.Value();
  }

  inline mozilla::dom::VideoTrack&
  GetAsVideoTrack() const
  {
    MOZ_RELEASE_ASSERT(IsVideoTrack(), "Wrong type!");
    return mValue.mVideoTrack.Value();
  }

  inline NonNull<mozilla::dom::AudioTrack>&
  RawSetAsAudioTrack()
  {
    if (mType == eAudioTrack) {
      return mValue.mAudioTrack.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eAudioTrack;
    return mValue.mAudioTrack.SetValue();
  }

  inline NonNull<mozilla::dom::AudioTrack>&
  SetAsAudioTrack()
  {
    if (mType == eAudioTrack) {
      return mValue.mAudioTrack.Value();
    }
    Uninit();
    mType = eAudioTrack;
    return mValue.mAudioTrack.SetValue();
  }

  inline bool
  IsAudioTrack() const
  {
    return mType == eAudioTrack;
  }

  inline NonNull<mozilla::dom::AudioTrack>&
  GetAsAudioTrack()
  {
    MOZ_RELEASE_ASSERT(IsAudioTrack(), "Wrong type!");
    return mValue.mAudioTrack.Value();
  }

  inline mozilla::dom::AudioTrack&
  GetAsAudioTrack() const
  {
    MOZ_RELEASE_ASSERT(IsAudioTrack(), "Wrong type!");
    return mValue.mAudioTrack.Value();
  }

  inline NonNull<mozilla::dom::TextTrack>&
  RawSetAsTextTrack()
  {
    if (mType == eTextTrack) {
      return mValue.mTextTrack.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTextTrack;
    return mValue.mTextTrack.SetValue();
  }

  inline NonNull<mozilla::dom::TextTrack>&
  SetAsTextTrack()
  {
    if (mType == eTextTrack) {
      return mValue.mTextTrack.Value();
    }
    Uninit();
    mType = eTextTrack;
    return mValue.mTextTrack.SetValue();
  }

  inline bool
  IsTextTrack() const
  {
    return mType == eTextTrack;
  }

  inline NonNull<mozilla::dom::TextTrack>&
  GetAsTextTrack()
  {
    MOZ_RELEASE_ASSERT(IsTextTrack(), "Wrong type!");
    return mValue.mTextTrack.Value();
  }

  inline mozilla::dom::TextTrack&
  GetAsTextTrack() const
  {
    MOZ_RELEASE_ASSERT(IsTextTrack(), "Wrong type!");
    return mValue.mTextTrack.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eVideoTrack: {
        DestroyVideoTrack();
        break;
      }
      case eAudioTrack: {
        DestroyAudioTrack();
        break;
      }
      case eTextTrack: {
        DestroyTextTrack();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToVideoTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToVideoTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyVideoTrack()
  {
    MOZ_RELEASE_ASSERT(IsVideoTrack(), "Wrong type!");
    mValue.mVideoTrack.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToAudioTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToAudioTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyAudioTrack()
  {
    MOZ_RELEASE_ASSERT(IsAudioTrack(), "Wrong type!");
    mValue.mAudioTrack.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToTextTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTextTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTextTrack()
  {
    MOZ_RELEASE_ASSERT(IsTextTrack(), "Wrong type!");
    mValue.mTextTrack.Destroy();
    mType = eUninitialized;
  }
};


class OwningVideoTrackOrAudioTrackOrTextTrack : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningVideoTrackOrAudioTrackOrTextTrack& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eVideoTrack,
    eAudioTrack,
    eTextTrack
  };
public:
  enum class Type
  {
    eVideoTrack = TypeOrUninit::eVideoTrack,
    eAudioTrack = TypeOrUninit::eAudioTrack,
    eTextTrack = TypeOrUninit::eTextTrack
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::VideoTrack> > mVideoTrack;
    UnionMember<OwningNonNull<mozilla::dom::AudioTrack> > mAudioTrack;
    UnionMember<OwningNonNull<mozilla::dom::TextTrack> > mTextTrack;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningVideoTrackOrAudioTrackOrTextTrack()
    : mType(eUninitialized)
  {
  }

  OwningVideoTrackOrAudioTrackOrTextTrack(OwningVideoTrackOrAudioTrackOrTextTrack&& aOther);

  explicit inline OwningVideoTrackOrAudioTrackOrTextTrack(const OwningVideoTrackOrAudioTrackOrTextTrack& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningVideoTrackOrAudioTrackOrTextTrack()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::VideoTrack>&
  RawSetAsVideoTrack();

  OwningNonNull<mozilla::dom::VideoTrack>&
  SetAsVideoTrack();

  inline bool
  IsVideoTrack() const
  {
    return mType == eVideoTrack;
  }

  inline OwningNonNull<mozilla::dom::VideoTrack>&
  GetAsVideoTrack()
  {
    MOZ_RELEASE_ASSERT(IsVideoTrack(), "Wrong type!");
    return mValue.mVideoTrack.Value();
  }

  inline OwningNonNull<mozilla::dom::VideoTrack> const &
  GetAsVideoTrack() const
  {
    MOZ_RELEASE_ASSERT(IsVideoTrack(), "Wrong type!");
    return mValue.mVideoTrack.Value();
  }

  OwningNonNull<mozilla::dom::AudioTrack>&
  RawSetAsAudioTrack();

  OwningNonNull<mozilla::dom::AudioTrack>&
  SetAsAudioTrack();

  inline bool
  IsAudioTrack() const
  {
    return mType == eAudioTrack;
  }

  inline OwningNonNull<mozilla::dom::AudioTrack>&
  GetAsAudioTrack()
  {
    MOZ_RELEASE_ASSERT(IsAudioTrack(), "Wrong type!");
    return mValue.mAudioTrack.Value();
  }

  inline OwningNonNull<mozilla::dom::AudioTrack> const &
  GetAsAudioTrack() const
  {
    MOZ_RELEASE_ASSERT(IsAudioTrack(), "Wrong type!");
    return mValue.mAudioTrack.Value();
  }

  OwningNonNull<mozilla::dom::TextTrack>&
  RawSetAsTextTrack();

  OwningNonNull<mozilla::dom::TextTrack>&
  SetAsTextTrack();

  inline bool
  IsTextTrack() const
  {
    return mType == eTextTrack;
  }

  inline OwningNonNull<mozilla::dom::TextTrack>&
  GetAsTextTrack()
  {
    MOZ_RELEASE_ASSERT(IsTextTrack(), "Wrong type!");
    return mValue.mTextTrack.Value();
  }

  inline OwningNonNull<mozilla::dom::TextTrack> const &
  GetAsTextTrack() const
  {
    MOZ_RELEASE_ASSERT(IsTextTrack(), "Wrong type!");
    return mValue.mTextTrack.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningVideoTrackOrAudioTrackOrTextTrack&
  operator=(OwningVideoTrackOrAudioTrackOrTextTrack&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningVideoTrackOrAudioTrackOrTextTrack&
  operator=(const OwningVideoTrackOrAudioTrackOrTextTrack& aOther);

private:
  bool
  TrySetToVideoTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToVideoTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyVideoTrack();

  bool
  TrySetToAudioTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToAudioTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyAudioTrack();

  bool
  TrySetToTextTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTextTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTextTrack();
};


struct TrackEventInit : public EventInit
{
  MOZ_INIT_OUTSIDE_CTOR Nullable<OwningVideoTrackOrAudioTrackOrTextTrack > mTrack;

  TrackEventInit();

  explicit inline TrackEventInit(const FastDictionaryInitializer& )
    : EventInit(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  TrackEventInit(TrackEventInit&& aOther) = default;

  explicit inline TrackEventInit(const TrackEventInit& aOther)
    : EventInit(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mTrack, "mTrack", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mTrack);
  }

  TrackEventInit&
  operator=(const TrackEventInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, TrackEventInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastTrackEventInit : public TrackEventInit
{
  inline FastTrackEventInit()
    : TrackEventInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace TrackEvent_Binding {

  typedef mozilla::dom::TrackEvent NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::TrackEvent* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::TrackEvent,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::TrackEvent,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::TrackEvent,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace TrackEvent_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_TrackEventBinding_h
