// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_glean_Pings_h
#define mozilla_glean_Pings_h

#include "mozilla/glean/bindings/Ping.h"

namespace mozilla::glean_pings {

/*
 * Generated from messaging-system.
 *
 * This is a ping representing single events triggered by the messaging system
 * and captures some pings from About:Welcome, ASRouter, and other corners.
 */
constexpr glean::impl::Ping MessagingSystem(1);

/*
 * Generated from newtab.
 *
 * Newtab-related instrumentation.
 * Can be disabled via the `newtabPingEnabled` variable of the `glean` Nimbus
 * feature, or the `browser.newtabpage.ping.enabled` pref.
 */
constexpr glean::impl::Ping Newtab(2);

/*
 * Generated from pageload.
 *
 * Instrumentation collected during a page load.
 */
constexpr glean::impl::Ping Pageload(3);

/*
 * Generated from background-tasks.
 *
 * This ping is generic for background tasks. Each background task can
 * gather its metrics under this ping and submit it when the task finishes.
 * Note that the ping submission must be done manually.
 */
constexpr glean::impl::Ping BackgroundTasks(4);

/*
 * Generated from crash.
 *
 * A ping to report crash information. This information is sent as soon as
 * possible after a crash occurs (whether the crash is a background/content
 * process or the main process). It is expected to be used for crash report
 * analysis and to reduce blind spots in crash reporting.
 */
constexpr glean::impl::Ping Crash(5);

/*
 * Generated from one-ping-only.
 *
 * This ping is for tests only.
 */
constexpr glean::impl::Ping OnePingOnly(6);

/*
 * Generated from test-ping.
 *
 * This ping is for tests only.
 */
constexpr glean::impl::Ping TestPing(7);

/*
 * Generated from first-startup.
 *
 * Sent during startup if Firefox was launched by the installer.
 */
constexpr glean::impl::Ping FirstStartup(8);

/*
 * Generated from background-update.
 *
 * This ping measures the technical health of the background update system.
 * Said system downloads and processes updates when Firefox is not running.  It
 * is expected that this ping will be analyzed by humans to gain confidence in
 * the implementation as the staged rollout of the system proceeds to the
 * release channel, before settling into an automated analysis to detect spikes
 * in background update failure rates.  This ping will also help to
 * characterize the update-related settings of our user population.
 * 
 * Right now the background update system, and therefore this ping, is
 * restricted to Windows.
 * 
 * This ping is submitted only by the background update task.  It should be
 * submitted once per background update task invocation.  The expected schedule
 * is every 7 hours, controlled by the pref `app.update.background.interval`,
 * and subject to scheduling decisions made by the OS.
 */
constexpr glean::impl::Ping BackgroundUpdate(9);


}  // namespace mozilla::glean_pings

#endif  // mozilla_glean_Pings_h
