/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */
#ifndef DAPTelemetryBindings_h
#error "Don't include this file directly, instead include DAPTelemetryBindings.h"
#endif


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

extern "C" {

extern bool dapHpkeEncryptOneshot(const uint8_t *aKey,
                                  uint32_t aKeyLength,
                                  const uint8_t *aInfo,
                                  uint32_t aInfoLength,
                                  const uint8_t *aAad,
                                  uint32_t aAadLength,
                                  const uint8_t *aPlaintext,
                                  uint32_t aPlaintextLength,
                                  nsTArray<uint8_t> *aOutputEncapsulatedKey,
                                  nsTArray<uint8_t> *aOutputShare);

/// Wraps the function above with minor C interop.
/// Mostly it turns any error result into a return value of false.
bool dapGetReportU8(const nsTArray<uint8_t> *leader_hpke_config_encoded,
                    const nsTArray<uint8_t> *helper_hpke_config_encoded,
                    uint8_t measurement,
                    const nsTArray<uint8_t> *task_id,
                    uint64_t time_precision,
                    nsTArray<uint8_t> *out_report);

bool dapGetReportVecU16(const nsTArray<uint8_t> *leader_hpke_config_encoded,
                        const nsTArray<uint8_t> *helper_hpke_config_encoded,
                        const nsTArray<uint16_t> *measurement,
                        const nsTArray<uint8_t> *task_id,
                        uint64_t time_precision,
                        nsTArray<uint8_t> *out_report);

extern void *dapStartCmac(uint8_t *aSeed);

extern void dapUpdateCmac(void *aContext, const uint8_t *aData, uint32_t aDataLen);

extern void dapFinalizeCmac(void *aContext, uint8_t *aMacOutput);

extern void dapReleaseCmac(void *aContext);

extern void *dapStartAesCtr(const uint8_t *aKey);

extern void dapCtrFillBuffer(void *aContext, uint8_t *aBuffer, int32_t aBufferSize);

extern void dapReleaseCtrCtx(void *aContext);

} // extern "C"
