/* THIS FILE IS AUTOGENERATED FROM ReadableStream.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ReadableStreamBinding_h
#define mozilla_dom_ReadableStreamBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/AbortSignal.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ReadableStream.h"
#include "mozilla/dom/WritableStream.h"

namespace mozilla {
namespace dom {

class AbortSignal;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
class ReadableStream;
struct ReadableStreamGetReaderOptionsAtoms;
struct ReadableStreamIteratorOptionsAtoms;
struct ReadableWritablePairAtoms;
struct StreamPipeOptionsAtoms;
class WritableStream;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class ReadableStreamReaderMode : uint8_t {
  Byob,
  EndGuard_
};

namespace ReadableStreamReaderModeValues {
extern const EnumEntry strings[2];

static constexpr size_t Count = 1;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ReadableStreamReaderMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ReadableStreamReaderMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ReadableStreamReaderModeValues

bool
ToJSValue(JSContext* aCx, ReadableStreamReaderMode aArgument, JS::MutableHandle<JS::Value> aValue);


struct ReadableStreamGetReaderOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<ReadableStreamReaderMode> mMode;

  ReadableStreamGetReaderOptions();

  explicit inline ReadableStreamGetReaderOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ReadableStreamGetReaderOptions(ReadableStreamGetReaderOptions&& aOther) = default;

  explicit inline ReadableStreamGetReaderOptions(const ReadableStreamGetReaderOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ReadableStreamGetReaderOptions&
  operator=(const ReadableStreamGetReaderOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ReadableStreamGetReaderOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastReadableStreamGetReaderOptions : public ReadableStreamGetReaderOptions
{
  inline FastReadableStreamGetReaderOptions()
    : ReadableStreamGetReaderOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ReadableStreamIteratorOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mPreventCancel;

  ReadableStreamIteratorOptions();

  explicit inline ReadableStreamIteratorOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ReadableStreamIteratorOptions(ReadableStreamIteratorOptions&& aOther) = default;

  explicit inline ReadableStreamIteratorOptions(const ReadableStreamIteratorOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ReadableStreamIteratorOptions&
  operator=(const ReadableStreamIteratorOptions& aOther);

  bool
  operator==(const ReadableStreamIteratorOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ReadableStreamIteratorOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastReadableStreamIteratorOptions : public ReadableStreamIteratorOptions
{
  inline FastReadableStreamIteratorOptions()
    : ReadableStreamIteratorOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ReadableWritablePair : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::dom::ReadableStream> mReadable;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::dom::WritableStream> mWritable;

  ReadableWritablePair();

  explicit inline ReadableWritablePair(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ReadableWritablePair(ReadableWritablePair&& aOther) = default;

  explicit inline ReadableWritablePair(const ReadableWritablePair& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mReadable, "mReadable", aFlags);
    ImplCycleCollectionTraverse(aCallback, mWritable, "mWritable", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mReadable);
    ImplCycleCollectionUnlink(mWritable);
  }

  ReadableWritablePair&
  operator=(const ReadableWritablePair& aOther);

private:
  static bool
  InitIds(JSContext* cx, ReadableWritablePairAtoms* atomsCache);
};

namespace binding_detail {
struct FastReadableWritablePair : public ReadableWritablePair
{
  inline FastReadableWritablePair()
    : ReadableWritablePair(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct StreamPipeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mPreventAbort;
  MOZ_INIT_OUTSIDE_CTOR bool mPreventCancel;
  MOZ_INIT_OUTSIDE_CTOR bool mPreventClose;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<mozilla::dom::AbortSignal>> mSignal;

  StreamPipeOptions();

  explicit inline StreamPipeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  StreamPipeOptions(StreamPipeOptions&& aOther) = default;

  explicit inline StreamPipeOptions(const StreamPipeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mSignal, "mSignal", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mSignal);
  }

  StreamPipeOptions&
  operator=(const StreamPipeOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, StreamPipeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastStreamPipeOptions : public StreamPipeOptions
{
  inline FastStreamPipeOptions()
    : StreamPipeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail




namespace ReadableStream_Binding {

  typedef mozilla::dom::ReadableStream NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::ReadableStream* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::ReadableStream,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::ReadableStream,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::ReadableStream,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace ReadableStream_Binding






} // namespace mozilla::dom

#endif // mozilla_dom_ReadableStreamBinding_h
