// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanBrowserModulesMetrics_h
#define mozilla_GleanBrowserModulesMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace browser_engagement {
  /**
   * generated from browser.engagement.active_ticks
   * The number of five-second intervals ('ticks') the user was considered
   * 'active'.
   * 
   * 'active' means keyboard or mouse interaction with the application.
   * It doesn't take into account whether or not the window has focus or is in
   * the foreground, only if it is receiving these interaction events.
   * 
   * Migrated from Telemetry's `browser.engagement.active_ticks`.
   */
  constexpr impl::CounterMetric active_ticks(20);

  /**
   * generated from browser.engagement.loaded_tab_count
   * Number of fully loaded (i.e., not pending from session restore) tabs opened across all windows, collected at most every 5 minutes whenever the user interacts with the browser in the following ways: open tab/window, page load, restoring a pending tab.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram LOADED_TAB_COUNT.
   */
  constexpr impl::CustomDistributionMetric loaded_tab_count(21);

  /**
   * generated from browser.engagement.max_concurrent_tab_count
   * The count of maximum number of tabs open during a subsession, across all windows, including tabs in private windows and restored at startup. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.max_concurrent_tab_count.
   */
  constexpr impl::QuantityMetric max_concurrent_tab_count(22);

  /**
   * generated from browser.engagement.max_concurrent_tab_pinned_count
   * The count of maximum number of pinned tabs open during a subsession. This includes private windows and the ones opened when starting the browser. Starting Firefox 85 this includes number of restored pinned tabs at startup. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.max_concurrent_tab_pinned_count.
   */
  constexpr impl::QuantityMetric max_concurrent_tab_pinned_count(23);

  /**
   * generated from browser.engagement.max_concurrent_vertical_tab_count
   * The count of maximum number of tabs with vertical tabs enabled. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.max_concurrent_vertical_tab_count.
   */
  constexpr impl::QuantityMetric max_concurrent_vertical_tab_count(24);

  /**
   * generated from browser.engagement.max_concurrent_vertical_tab_pinned_count
   * The count of maximum number of pinned tabs with vertical tabs enabled. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.max_concurrent_vertical_tab_pinned_count.
   */
  constexpr impl::QuantityMetric max_concurrent_vertical_tab_pinned_count(25);

  /**
   * generated from browser.engagement.max_concurrent_window_count
   * The count of maximum number of browser windows open during a subsession. This includes private windows and the ones opened when starting the browser. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.max_concurrent_window_count.
   */
  constexpr impl::QuantityMetric max_concurrent_window_count(26);

  /**
   * generated from browser.engagement.profile_count
   * Windows only count of the browser profiles on the current system. This
   * counts profiles that have been used across all Windows user accounts on
   * machine since this probe was added. The value persists across installs.
   * A value of 0 is reported if there is an error determining the correct
   * count. Unset on other platforms.
   */
  constexpr impl::QuantityMetric profile_count(27);

  /**
   * generated from browser.engagement.tab_count
   * Number of tabs opened across all windows, collected at most every 5 minutes whenever the user interacts with the browser in the following ways: open tab/window, page load.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TAB_COUNT.
   */
  constexpr impl::CustomDistributionMetric tab_count(28);

  /**
   * generated from browser.engagement.tab_open_event_count
   * The count of tab open events per subsession, across all windows, after the session has been restored. This includes tab open events from private windows and from manual session restorations (i.e. after crashes and from about:home), but excludes tabs opened vertically. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.tab_open_event_count.
   */
  constexpr impl::CounterMetric tab_open_event_count(29);

  /**
   * generated from browser.engagement.tab_pinned_event_count
   * The count of tab pinned events per subsession, across all windows, after the session has been restored. This includes tab pinned events from private windows. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.tab_pinned_event_count.
   */
  constexpr impl::CounterMetric tab_pinned_event_count(30);

  /**
   * generated from browser.engagement.unfiltered_uri_count
   * The count of the total non-unique URIs visited in a subsession, not restricted to a specific protocol, including page reloads and about:* pages (other than initial pages such as about:blank, ...), after the session has been restored. This does not include background page requests and URIs from embedded pages or private browsing. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.unfiltered_uri_count.
   */
  constexpr impl::CounterMetric unfiltered_uri_count(31);

  /**
   * generated from browser.engagement.unique_domains_count
   * The count of the unique domains visited in a subsession, after the session has been restored. Subdomains under eTLD are aggregated after the first level (i.e. test.example.com and other.example.com are only counted once). This does not include background page requests and domains from embedded pages or private browsing. The count is limited to 100 unique domains. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.unique_domains_count.
   */
  constexpr impl::QuantityMetric unique_domains_count(32);

  /**
   * generated from browser.engagement.uri_count
   * The number of total non-unique http(s) URIs visited, including page
   * reloads, after the session has been restored. URIs on minimized or
   * background tabs may also be counted. Private browsing uris are included.
   * 
   * Migrated from Telemetry's
   * `browser.engagement.total_uri_count_normal_and_private_mode`.
   */
  constexpr impl::CounterMetric uri_count(33);

  /**
   * generated from browser.engagement.uri_count_normal_mode
   * The count of the total non-unique http(s) URIs visited in a subsession, including page reloads, after the session has been restored. URIs on minimized or background tabs may also be counted towards this. Private browsing is not included in this count. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.total_uri_count.
   */
  constexpr impl::CounterMetric uri_count_normal_mode(34);

  /**
   * generated from browser.engagement.vertical_tab_open_event_count
   * The count of tab open events with vertical tabs enabled. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.vertical_tab_open_event_count.
   */
  constexpr impl::CounterMetric vertical_tab_open_event_count(35);

  /**
   * generated from browser.engagement.vertical_tab_pinned_event_count
   * The count of tab pinned events with vertical tabs enabled. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.vertical_tab_pinned_event_count.
   */
  constexpr impl::CounterMetric vertical_tab_pinned_event_count(36);

  /**
   * generated from browser.engagement.window_open_event_count
   * The count of browser window open events per subsession, after the session has been restored. The count includes private windows and the ones from manual session restorations (i.e. after crashes and from about:home). This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.window_open_event_count.
   */
  constexpr impl::CounterMetric window_open_event_count(37);
}

namespace glam_experiment {
  /**
   * generated from glam_experiment.active_ticks
   * Duplicate of:
   * `browser.engagement.active_ticks`
   * 
   * Intended for the purpose of testing client side sampling of data. This
   * metric is disabled by default and will be enabled only for the purpose
   * of the experiment. See Bug 1947604 for more information.
   */
  constexpr impl::CounterMetric active_ticks(296);
}

namespace browser_ui_interaction {
  /**
   * generated from browser.ui.interaction.app_menu
   * Records a count of interactions with items in the app menu. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.app_menu.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> app_menu(880);

  /**
   * generated from browser.ui.interaction.bookmarks_bar
   * Records a count of interactions with items in the bookmarks bar. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.bookmarks_bar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> bookmarks_bar(881);

  /**
   * generated from browser.ui.interaction.content_context
   * Records a count of interactions with items in the content context menu. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.content_context.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> content_context(882);

  /**
   * generated from browser.ui.interaction.menu_bar
   * Records a count of interactions with items in the menu bar. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.menu_bar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> menu_bar(883);

  /**
   * generated from browser.ui.interaction.nav_bar
   * Records a count of interactions with items in the nav bar. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.nav_bar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> nav_bar(884);

  /**
   * generated from browser.ui.interaction.overflow_menu
   * Records a count of interactions with items in the overflow menu. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.overflow_menu.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> overflow_menu(885);

  /**
   * generated from browser.ui.interaction.pageaction_panel
   * Records a count of interactions with page action items in the panel. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.pageaction_panel.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> pageaction_panel(886);

  /**
   * generated from browser.ui.interaction.pageaction_urlbar
   * Records a count of interactions with page action items in the url bar. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.pageaction_urlbar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> pageaction_urlbar(887);

  /**
   * generated from browser.ui.interaction.pinned_overflow_menu
   * Records a count of interactions with items in the pinned area of the overflow menu. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.pinned_overflow_menu.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> pinned_overflow_menu(888);

  /**
   * generated from browser.ui.interaction.preferences_pane_containers
   * Records the items interacted with in the Containers section of preferences. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.preferences_paneContainers.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> preferences_pane_containers(889);

  /**
   * generated from browser.ui.interaction.preferences_pane_experimental
   * Records the items interacted with in the Experimental section of preferences. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.preferences_paneExperimental.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> preferences_pane_experimental(890);

  /**
   * generated from browser.ui.interaction.preferences_pane_general
   * Records the items interacted with in the General section of preferences. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.preferences_paneGeneral.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> preferences_pane_general(891);

  /**
   * generated from browser.ui.interaction.preferences_pane_home
   * Records the items interacted with in the Home section of preferences. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.preferences_paneHome.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> preferences_pane_home(892);

  /**
   * generated from browser.ui.interaction.preferences_pane_more_from_mozilla
   * Records the items interacted with in the More From Mozilla section of preferences. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.preferences_paneMoreFromMozilla.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> preferences_pane_more_from_mozilla(893);

  /**
   * generated from browser.ui.interaction.preferences_pane_privacy
   * Records the items interacted with in the Privacy section of preferences. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.preferences_panePrivacy.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> preferences_pane_privacy(894);

  /**
   * generated from browser.ui.interaction.preferences_pane_search
   * Records the items interacted with in the Search section of preferences. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.preferences_paneSearch.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> preferences_pane_search(895);

  /**
   * generated from browser.ui.interaction.preferences_pane_search_results
   * Records the items interacted with in the Search results section of preferences. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.preferences_paneSearchResults.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> preferences_pane_search_results(896);

  /**
   * generated from browser.ui.interaction.preferences_pane_sync
   * Records the items interacted with in the Sync section of preferences. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.preferences_paneSync.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> preferences_pane_sync(897);

  /**
   * generated from browser.ui.interaction.preferences_pane_unknown
   * Records the items interacted with in any other section of preferences. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.preferences_paneUnknown.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> preferences_pane_unknown(898);

  /**
   * generated from browser.ui.interaction.tabs_bar
   * Records a count of interactions with items in the tab bar. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.tabs_bar.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> tabs_bar(899);

  /**
   * generated from browser.ui.interaction.tabs_context
   * Records a count of interactions with items in the tab context menu. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.tabs_context.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> tabs_context(900);

  /**
   * generated from browser.ui.interaction.tabs_context_entrypoint
   * Records a count for each entrypoint (the container of the trigger node) when an item from the tabs context menu is selected. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.tabs_context_entrypoint.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> tabs_context_entrypoint(901);

  /**
   * generated from browser.ui.interaction.unified_extensions_area
   * Records a count of interactions with items in the Unified Extensions area. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.unified_extensions_area.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> unified_extensions_area(902);

  /**
   * generated from browser.ui.interaction.vertical_tabs_container
   * Records a count of interactions with items in the vertical tab bar. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.vertical_tabs_container.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> vertical_tabs_container(903);
}

namespace browser_content_crash {
  /**
   * generated from browser.content_crash.dump_unavailable
   * Counts the number of times that about:tabcrashed was unable to find a crash dump.
   * This metric was generated to correspond to the Legacy Telemetry count histogram FX_CONTENT_CRASH_DUMP_UNAVAILABLE.
   */
  constexpr impl::CounterMetric dump_unavailable(972);

  /**
   * generated from browser.content_crash.not_submitted
   * Counts the number of times that about:tabcrashed was unloaded without submitting.
   * This metric was generated to correspond to the Legacy Telemetry count histogram FX_CONTENT_CRASH_NOT_SUBMITTED.
   */
  constexpr impl::CounterMetric not_submitted(973);
}

namespace browser_sanitizer {
  /**
   * generated from browser.sanitizer.cache
   * Sanitize: Time it takes to sanitize the cache (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SANITIZE_CACHE.
   */
  constexpr impl::TimingDistributionMetric cache(974);

  /**
   * generated from browser.sanitizer.cookies
   * Sanitize: Time it takes to sanitize firefox cookies (ms). A subset of FX_SANITIZE_COOKIES.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SANITIZE_COOKIES_2.
   */
  constexpr impl::TimingDistributionMetric cookies(975);

  /**
   * generated from browser.sanitizer.downloads
   * Sanitize: Time it takes to sanitize recent downloads (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SANITIZE_DOWNLOADS.
   */
  constexpr impl::TimingDistributionMetric downloads(976);

  /**
   * generated from browser.sanitizer.formdata
   * Sanitize: Time it takes to sanitize stored form data (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SANITIZE_FORMDATA.
   */
  constexpr impl::TimingDistributionMetric formdata(977);

  /**
   * generated from browser.sanitizer.history
   * Sanitize: Time it takes to sanitize history (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SANITIZE_HISTORY.
   */
  constexpr impl::TimingDistributionMetric history(978);

  /**
   * generated from browser.sanitizer.openwindows
   * Sanitize: Time it takes to sanitize the open windows list (ms). On Android, this is the time it takes to close all open tabs (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SANITIZE_OPENWINDOWS.
   */
  constexpr impl::TimingDistributionMetric openwindows(979);

  /**
   * generated from browser.sanitizer.sessions
   * Sanitize: Time it takes to sanitize saved sessions (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SANITIZE_SESSIONS.
   */
  constexpr impl::TimingDistributionMetric sessions(980);

  /**
   * generated from browser.sanitizer.sitesettings
   * Sanitize: Time it takes to sanitize site-specific settings (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SANITIZE_SITESETTINGS.
   */
  constexpr impl::TimingDistributionMetric sitesettings(981);

  /**
   * generated from browser.sanitizer.total
   * Sanitize: Total time it takes to sanitize (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SANITIZE_TOTAL.
   */
  constexpr impl::TimingDistributionMetric total(982);
}

namespace browser_ui {
  /**
   * generated from browser.ui.customized_widgets
   * Records when widgets are added, removed or moved in the UI. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.customized_widgets.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> customized_widgets(983);

  /**
   * generated from browser.ui.mirror_for_toolbar_widgets
   * The widgets in the toolbars. See https://firefox-source- docs.mozilla.org/browser/BrowserUsageTelemetry.html This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.toolbar_widgets.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> mirror_for_toolbar_widgets(984);

}

namespace browser_usage {
  /**
   * generated from browser.usage.interaction
   */
  struct InteractionExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> widgetId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (widgetId) {
        extraKeys.AppendElement()->AssignASCII("widget_id");
        extraValues.EmplaceBack(widgetId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The user interacted with something in the Firefox Desktop frontend. Could be via mouse or keyboard, could be a command or a UI element.
   */
  constexpr impl::EventMetric<InteractionExtra> interaction(986);
}

namespace contextual_services {
  /**
   * generated from contextual_services.context_id
   * An identifier for Contextual Services user interaction pings. This is used internally for counting unique users as well as for anti-fraud. It is shared with other Contextual Services.
   * Does not need to be sent in the Glean "deletion-request" ping. It is sent in its own "context-id-deletion-request" ping.
   */
  constexpr impl::UuidMetric context_id(987);
}

namespace homepage {
  /**
   * generated from homepage.preference_ignore
   */
  struct PreferenceIgnoreExtra {
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> webextensionid;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (webextensionid) {
        extraKeys.AppendElement()->AssignASCII("webExtensionId");
        extraValues.EmplaceBack(webextensionid.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded whenever the homepage preference is either reset due to being on the ignore list, or setting is blocked due to being on the same list. The value field records the reason for the ignore. "saved_reset" for when a saved preference value is reset. "set_blocked" for when the setting was blocked and "set_blocked_extension" for when we know a WebExtension attempting to set it was blocked. This event was generated to correspond to the Legacy Telemetry event homepage.preference#ignore.
   */
  constexpr impl::EventMetric<PreferenceIgnoreExtra> preference_ignore(988);
}

namespace installation {
  /**
   * generated from installation.first_seen_full
   */
  struct FirstSeenFullExtra {
    mozilla::Maybe<nsCString> adminUser;
    mozilla::Maybe<nsCString> buildId;
    mozilla::Maybe<nsCString> defaultPath;
    mozilla::Maybe<nsCString> fromMsi;
    mozilla::Maybe<nsCString> installExisted;
    mozilla::Maybe<nsCString> otherInst;
    mozilla::Maybe<nsCString> otherMsixInst;
    mozilla::Maybe<nsCString> profdirExisted;
    mozilla::Maybe<nsCString> silent;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (adminUser) {
        extraKeys.AppendElement()->AssignASCII("admin_user");
        extraValues.EmplaceBack(adminUser.value());
      }
      if (buildId) {
        extraKeys.AppendElement()->AssignASCII("build_id");
        extraValues.EmplaceBack(buildId.value());
      }
      if (defaultPath) {
        extraKeys.AppendElement()->AssignASCII("default_path");
        extraValues.EmplaceBack(defaultPath.value());
      }
      if (fromMsi) {
        extraKeys.AppendElement()->AssignASCII("from_msi");
        extraValues.EmplaceBack(fromMsi.value());
      }
      if (installExisted) {
        extraKeys.AppendElement()->AssignASCII("install_existed");
        extraValues.EmplaceBack(installExisted.value());
      }
      if (otherInst) {
        extraKeys.AppendElement()->AssignASCII("other_inst");
        extraValues.EmplaceBack(otherInst.value());
      }
      if (otherMsixInst) {
        extraKeys.AppendElement()->AssignASCII("other_msix_inst");
        extraValues.EmplaceBack(otherMsixInst.value());
      }
      if (profdirExisted) {
        extraKeys.AppendElement()->AssignASCII("profdir_existed");
        extraValues.EmplaceBack(profdirExisted.value());
      }
      if (silent) {
        extraKeys.AppendElement()->AssignASCII("silent");
        extraValues.EmplaceBack(silent.value());
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded after the application has been installed or reinstalled, the first time that a profile sees that there was a new installation. This includes information about how the installer was run. This event was generated to correspond to the Legacy Telemetry event installation.first_seen#full.
   */
  constexpr impl::EventMetric<FirstSeenFullExtra> first_seen_full(989);

  /**
   * generated from installation.first_seen_msix
   */
  struct FirstSeenMsixExtra {
    mozilla::Maybe<nsCString> adminUser;
    mozilla::Maybe<nsCString> buildId;
    mozilla::Maybe<nsCString> defaultPath;
    mozilla::Maybe<nsCString> fromMsi;
    mozilla::Maybe<nsCString> installExisted;
    mozilla::Maybe<nsCString> otherInst;
    mozilla::Maybe<nsCString> otherMsixInst;
    mozilla::Maybe<nsCString> profdirExisted;
    mozilla::Maybe<nsCString> silent;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (adminUser) {
        extraKeys.AppendElement()->AssignASCII("admin_user");
        extraValues.EmplaceBack(adminUser.value());
      }
      if (buildId) {
        extraKeys.AppendElement()->AssignASCII("build_id");
        extraValues.EmplaceBack(buildId.value());
      }
      if (defaultPath) {
        extraKeys.AppendElement()->AssignASCII("default_path");
        extraValues.EmplaceBack(defaultPath.value());
      }
      if (fromMsi) {
        extraKeys.AppendElement()->AssignASCII("from_msi");
        extraValues.EmplaceBack(fromMsi.value());
      }
      if (installExisted) {
        extraKeys.AppendElement()->AssignASCII("install_existed");
        extraValues.EmplaceBack(installExisted.value());
      }
      if (otherInst) {
        extraKeys.AppendElement()->AssignASCII("other_inst");
        extraValues.EmplaceBack(otherInst.value());
      }
      if (otherMsixInst) {
        extraKeys.AppendElement()->AssignASCII("other_msix_inst");
        extraValues.EmplaceBack(otherMsixInst.value());
      }
      if (profdirExisted) {
        extraKeys.AppendElement()->AssignASCII("profdir_existed");
        extraValues.EmplaceBack(profdirExisted.value());
      }
      if (silent) {
        extraKeys.AppendElement()->AssignASCII("silent");
        extraValues.EmplaceBack(silent.value());
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded after the application has been installed or reinstalled, the first time that a profile sees that there was a new installation. This includes information about how the installer was run. This event was generated to correspond to the Legacy Telemetry event installation.first_seen#msix.
   */
  constexpr impl::EventMetric<FirstSeenMsixExtra> first_seen_msix(990);

  /**
   * generated from installation.first_seen_stub
   */
  struct FirstSeenStubExtra {
    mozilla::Maybe<nsCString> adminUser;
    mozilla::Maybe<nsCString> buildId;
    mozilla::Maybe<nsCString> defaultPath;
    mozilla::Maybe<nsCString> fromMsi;
    mozilla::Maybe<nsCString> installExisted;
    mozilla::Maybe<nsCString> otherInst;
    mozilla::Maybe<nsCString> otherMsixInst;
    mozilla::Maybe<nsCString> profdirExisted;
    mozilla::Maybe<nsCString> silent;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (adminUser) {
        extraKeys.AppendElement()->AssignASCII("admin_user");
        extraValues.EmplaceBack(adminUser.value());
      }
      if (buildId) {
        extraKeys.AppendElement()->AssignASCII("build_id");
        extraValues.EmplaceBack(buildId.value());
      }
      if (defaultPath) {
        extraKeys.AppendElement()->AssignASCII("default_path");
        extraValues.EmplaceBack(defaultPath.value());
      }
      if (fromMsi) {
        extraKeys.AppendElement()->AssignASCII("from_msi");
        extraValues.EmplaceBack(fromMsi.value());
      }
      if (installExisted) {
        extraKeys.AppendElement()->AssignASCII("install_existed");
        extraValues.EmplaceBack(installExisted.value());
      }
      if (otherInst) {
        extraKeys.AppendElement()->AssignASCII("other_inst");
        extraValues.EmplaceBack(otherInst.value());
      }
      if (otherMsixInst) {
        extraKeys.AppendElement()->AssignASCII("other_msix_inst");
        extraValues.EmplaceBack(otherMsixInst.value());
      }
      if (profdirExisted) {
        extraKeys.AppendElement()->AssignASCII("profdir_existed");
        extraValues.EmplaceBack(profdirExisted.value());
      }
      if (silent) {
        extraKeys.AppendElement()->AssignASCII("silent");
        extraValues.EmplaceBack(silent.value());
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded after the application has been installed or reinstalled, the first time that a profile sees that there was a new installation. This includes information about how the installer was run. This event was generated to correspond to the Legacy Telemetry event installation.first_seen#stub.
   */
  constexpr impl::EventMetric<FirstSeenStubExtra> first_seen_stub(991);
}

namespace installation_first_seen {
  /**
   * generated from installation.first_seen.admin_user
   * Whether the installer is running from an elevated admin user
   */
  constexpr impl::BooleanMetric admin_user(992);

  /**
   * generated from installation.first_seen.default_path
   * (optional, present if installer_type is "full") Whether the default path was used
   */
  constexpr impl::BooleanMetric default_path(993);

  /**
   * generated from installation.first_seen.failure_reason
   * Only sent if unable to collect firstSeen data. Can have value "NotFoundError" if file not found or other values depending on the failure reason.
   */
  constexpr impl::StringMetric failure_reason(994);

  /**
   * generated from installation.first_seen.from_msi
   * (optional, present if installer_type is "full") Whether this was an MSI install
   */
  constexpr impl::BooleanMetric from_msi(995);

  /**
   * generated from installation.first_seen.install_existed
   * Whether there was already an install in this location
   */
  constexpr impl::BooleanMetric install_existed(996);

  /**
   * generated from installation.first_seen.installer_type
   * The type of installer used to install Firefox. The value is one of "stub", "full", or "msix"
   */
  constexpr impl::StringMetric installer_type(997);

  /**
   * generated from installation.first_seen.other_inst
   * Whether there was already any non-MSIX install on this system
   */
  constexpr impl::BooleanMetric other_inst(998);

  /**
   * generated from installation.first_seen.other_msix_inst
   * Whether there was already any MSIX install on this system
   */
  constexpr impl::BooleanMetric other_msix_inst(999);

  /**
   * generated from installation.first_seen.profdir_existed
   * Whether the top-level profile directory existed
   */
  constexpr impl::BooleanMetric profdir_existed(1000);

  /**
   * generated from installation.first_seen.silent
   * (optional, present if installer_type is "full") Whether this was a silent install
   */
  constexpr impl::BooleanMetric silent(1001);

  /**
   * generated from installation.first_seen.version
   * The application version installed by the installer (not necessarily the current version)
   */
  constexpr impl::StringMetric version(1002);
}

namespace link_icon_sizes_attr {
  /**
   * generated from link_icon_sizes_attr.dimension
   * The width dimension of the 'sizes' attribute for <link rel=icon>.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram LINK_ICON_SIZES_ATTR_DIMENSION.
   */
  constexpr impl::CustomDistributionMetric dimension(1003);

  /**
   * generated from link_icon_sizes_attr.usage
   * The possible types of the 'sizes' attribute for <link rel=icon>. 0: Attribute not specified, 1: 'any', 2: Integer dimensions, 3: Invalid value.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram LINK_ICON_SIZES_ATTR_USAGE.
   */
  constexpr impl::CustomDistributionMetric usage(1004);
}

namespace partner_link {
  /**
   * generated from partner_link.attribution_abort
   */
  struct AttributionAbortExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded when sending an attribution request for a partner link. The value is the partner. This event was generated to correspond to the Legacy Telemetry event partner_link.attribution#abort.
   */
  constexpr impl::EventMetric<AttributionAbortExtra> attribution_abort(1005);

  /**
   * generated from partner_link.attribution_failure
   */
  struct AttributionFailureExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded when sending an attribution request for a partner link. The value is the partner. This event was generated to correspond to the Legacy Telemetry event partner_link.attribution#failure.
   */
  constexpr impl::EventMetric<AttributionFailureExtra> attribution_failure(1006);

  /**
   * generated from partner_link.attribution_success
   */
  struct AttributionSuccessExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded when sending an attribution request for a partner link. The value is the partner. This event was generated to correspond to the Legacy Telemetry event partner_link.attribution#success.
   */
  constexpr impl::EventMetric<AttributionSuccessExtra> attribution_success(1007);

  /**
   * generated from partner_link.click_newtab
   */
  struct ClickNewtabExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded when clicking a partner link. The value is the partner. This event was generated to correspond to the Legacy Telemetry event partner_link.click#newtab.
   */
  constexpr impl::EventMetric<ClickNewtabExtra> click_newtab(1008);

  /**
   * generated from partner_link.click_urlbar
   */
  struct ClickUrlbarExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded when clicking a partner link. The value is the partner. This event was generated to correspond to the Legacy Telemetry event partner_link.click#urlbar.
   */
  constexpr impl::EventMetric<ClickUrlbarExtra> click_urlbar(1009);
}

namespace performance_interaction {
  /**
   * generated from performance.interaction.tab_switch_composite
   * Time between tab selection and first composite of the tab content onto the screen. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric tab_switch_composite(1010);
}

namespace timestamps {
  /**
   * generated from timestamps.about_home_topsites_first_paint
   * Record the timestamp of when the first about:home's Topsites are painted. Only records if about:home is set as the default homepage, and if sessions are not being restored by default. This metric was generated to correspond to the Legacy Telemetry scalar timestamps.about_home_topsites_first_paint.
   */
  constexpr impl::QuantityMetric about_home_topsites_first_paint(1013);
}

} // namespace mozilla::glean

#endif // mozilla_GleanBrowserModulesMetrics_h
