// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitMozappsUpdateMetrics_h
#define mozilla_GleanToolkitMozappsUpdateMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace update {
  /**
   * generated from update.bits_result_complete
   * Update: Result code from downloading a complete update via BITS
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_BITS_RESULT_COMPLETE.
   */
  constexpr impl::CustomDistributionMetric bits_result_complete(5999);

  /**
   * generated from update.bits_result_partial
   * Update: Result code from downloading a partial update via BITS
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_BITS_RESULT_PARTIAL.
   */
  constexpr impl::CustomDistributionMetric bits_result_partial(6000);

  /**
   * generated from update.can_use_bits_external
   */
  enum class CanUseBitsExternalLabel: uint16_t {
    eCanusebits = 0,
    eNobitsNotwindows = 1,
    eNobitsFeatureoff = 2,
    eNobitsPref = 3,
    eNobitsProxy = 4,
    eNobitsOtheruser = 5,
    e__Other__,
  };
  /**
   * Update: Whether BITS could be used to download updates (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_CAN_USE_BITS_EXTERNAL.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CanUseBitsExternalLabel> can_use_bits_external(6001);

  /**
   * generated from update.can_use_bits_notify
   */
  enum class CanUseBitsNotifyLabel: uint16_t {
    eCanusebits = 0,
    eNobitsNotwindows = 1,
    eNobitsFeatureoff = 2,
    eNobitsPref = 3,
    eNobitsProxy = 4,
    eNobitsOtheruser = 5,
    e__Other__,
  };
  /**
   * Update: Whether BITS could be used to download updates (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_CAN_USE_BITS_NOTIFY.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CanUseBitsNotifyLabel> can_use_bits_notify(6002);

  /**
   * generated from update.can_use_bits_subsequent
   */
  enum class CanUseBitsSubsequentLabel: uint16_t {
    eCanusebits = 0,
    eNobitsNotwindows = 1,
    eNobitsFeatureoff = 2,
    eNobitsPref = 3,
    eNobitsProxy = 4,
    eNobitsOtheruser = 5,
    e__Other__,
  };
  /**
   * Update: Whether BITS could be used to download updates (after we already have an update ready)
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_CAN_USE_BITS_SUBSEQUENT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CanUseBitsSubsequentLabel> can_use_bits_subsequent(6003);

  /**
   * generated from update.cannot_stage_external
   * Update: count of systems that cannot stage updates (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CANNOT_STAGE_EXTERNAL.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cannot_stage_external(6004);

  /**
   * generated from update.cannot_stage_notify
   * Update: count of systems that cannot stage updates (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CANNOT_STAGE_NOTIFY.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cannot_stage_notify(6005);

  /**
   * generated from update.cannot_stage_subsequent
   * Update: count of systems that cannot stage updates (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CANNOT_STAGE_SUBSEQUENT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> cannot_stage_subsequent(6006);

  /**
   * generated from update.check_code_external
   * Update: background update check result code except for no updates found (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_CHECK_CODE_EXTERNAL.
   */
  constexpr impl::CustomDistributionMetric check_code_external(6007);

  /**
   * generated from update.check_code_notify
   * Update: background update check result code except for no updates found (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_CHECK_CODE_NOTIFY.
   */
  constexpr impl::CustomDistributionMetric check_code_notify(6008);

  /**
   * generated from update.check_code_subsequent
   * Update: background update check result code except for no updates found (after we already have an update ready). Possible codes are enumerated by constants starting with CHK_ in toolkit/mozapps/update/UpdateTelemetry.sys.mjs
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_CHECK_CODE_SUBSEQUENT.
   */
  constexpr impl::CustomDistributionMetric check_code_subsequent(6009);

  /**
   * generated from update.check_extended_error_external
   * Update: keyed count (key names are prefixed with AUS_CHECK_EX_ERR_) of background update check extended error code (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_EXTENDED_ERROR_EXTERNAL.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> check_extended_error_external(6010);

  /**
   * generated from update.check_extended_error_notify
   * Update: keyed count (key names are prefixed with AUS_CHECK_EX_ERR_) of background update check extended error code (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_EXTENDED_ERROR_NOTIFY.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> check_extended_error_notify(6011);

  /**
   * generated from update.check_extended_error_subsequent
   * Update: keyed count (key names are prefixed with AUS_CHECK_EX_ERR_) of background update check extended error code (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_EXTENDED_ERROR_SUBSEQUENT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> check_extended_error_subsequent(6012);

  /**
   * generated from update.check_no_update_external
   * Update: count of no updates were found for a background update check (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_NO_UPDATE_EXTERNAL.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> check_no_update_external(6013);

  /**
   * generated from update.check_no_update_notify
   * Update: count of no updates were found for a background update check (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_NO_UPDATE_NOTIFY.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> check_no_update_notify(6014);

  /**
   * generated from update.check_no_update_subsequent
   * Update: count of no updates were found for a background update check (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_CHECK_NO_UPDATE_SUBSEQUENT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> check_no_update_subsequent(6015);

  /**
   * generated from update.download_code_complete
   * Update: complete patch type download result code
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_DOWNLOAD_CODE_COMPLETE.
   */
  constexpr impl::CustomDistributionMetric download_code_complete(6016);

  /**
   * generated from update.download_code_partial
   * Update: partial patch type download result code
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_DOWNLOAD_CODE_PARTIAL.
   */
  constexpr impl::CustomDistributionMetric download_code_partial(6017);

  /**
   * generated from update.download_code_unknown
   * Update: unknown patch type download result code
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_DOWNLOAD_CODE_UNKNOWN.
   */
  constexpr impl::CustomDistributionMetric download_code_unknown(6018);

  /**
   * generated from update.invalid_lastupdatetime_external
   * Update: count of systems that have a last update time greater than the current time (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_INVALID_LASTUPDATETIME_EXTERNAL.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> invalid_lastupdatetime_external(6019);

  /**
   * generated from update.invalid_lastupdatetime_notify
   * Update: count of systems that have a last update time greater than the current time (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_INVALID_LASTUPDATETIME_NOTIFY.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> invalid_lastupdatetime_notify(6020);

  /**
   * generated from update.invalid_lastupdatetime_subsequent
   * Update: count of systems that have a last update time greater than the current time (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_INVALID_LASTUPDATETIME_SUBSEQUENT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> invalid_lastupdatetime_subsequent(6021);

  /**
   * generated from update.langpack_overtime
   * Update: How much longer langpacks took to download than the app update in seconds.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram UPDATE_LANGPACK_OVERTIME.
   */
  constexpr impl::TimingDistributionMetric langpack_overtime(6022);

  /**
   * generated from update.last_notify_interval_days_external
   * Update: interval in days since the last background update check (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram UPDATE_LAST_NOTIFY_INTERVAL_DAYS_EXTERNAL.
   */
  constexpr impl::TimingDistributionMetric last_notify_interval_days_external(6023);

  /**
   * generated from update.last_notify_interval_days_notify
   * Update: interval in days since the last background update check (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram UPDATE_LAST_NOTIFY_INTERVAL_DAYS_NOTIFY.
   */
  constexpr impl::TimingDistributionMetric last_notify_interval_days_notify(6024);

  /**
   * generated from update.last_notify_interval_days_subsequent
   * Update: interval in days since the last background update check (after we already have an update ready)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram UPDATE_LAST_NOTIFY_INTERVAL_DAYS_SUBSEQUENT.
   */
  constexpr impl::TimingDistributionMetric last_notify_interval_days_subsequent(6025);

  /**
   * generated from update.not_pref_update_auto_external
   * Update: count of when getAppUpdateAutoEnabled from UpdateUtils.sys.mjs does not return the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_AUTO_EXTERNAL.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> not_pref_update_auto_external(6026);

  /**
   * generated from update.not_pref_update_auto_notify
   * Update: count of when getAppUpdateAutoEnabled from UpdateUtils.sys.mjs does not return the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_AUTO_NOTIFY.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> not_pref_update_auto_notify(6027);

  /**
   * generated from update.not_pref_update_auto_subsequent
   * Update: count of when getAppUpdateAutoEnabled from UpdateUtils.sys.mjs does not return the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_AUTO_SUBSEQUENT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> not_pref_update_auto_subsequent(6028);

  /**
   * generated from update.not_pref_update_service_enabled_external
   * Update: count of when the app.update.service.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_SERVICE_ENABLED_EXTERNAL.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> not_pref_update_service_enabled_external(6029);

  /**
   * generated from update.not_pref_update_service_enabled_notify
   * Update: count of when the app.update.service.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_SERVICE_ENABLED_NOTIFY.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> not_pref_update_service_enabled_notify(6030);

  /**
   * generated from update.not_pref_update_service_enabled_subsequent
   * Update: count of when the app.update.service.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_SERVICE_ENABLED_SUBSEQUENT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> not_pref_update_service_enabled_subsequent(6031);

  /**
   * generated from update.not_pref_update_staging_enabled_external
   * Update: count of when the app.update.staging.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_STAGING_ENABLED_EXTERNAL.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> not_pref_update_staging_enabled_external(6032);

  /**
   * generated from update.not_pref_update_staging_enabled_notify
   * Update: count of when the app.update.staging.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_STAGING_ENABLED_NOTIFY.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> not_pref_update_staging_enabled_notify(6033);

  /**
   * generated from update.not_pref_update_staging_enabled_subsequent
   * Update: count of when the app.update.staging.enabled boolean preference is not the default value of true (true values are not submitted)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_NOT_PREF_UPDATE_STAGING_ENABLED_SUBSEQUENT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> not_pref_update_staging_enabled_subsequent(6034);

  /**
   * generated from update.notification_badge_shown
   */
  enum class NotificationBadgeShownLabel: uint16_t {
    eRestart = 0,
    eAvailable = 1,
    eManual = 2,
    eUnsupported = 3,
    eOtherinstance = 4,
    e__Other__,
  };
  /**
   * Update: the application update badge type that was displayed.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_NOTIFICATION_BADGE_SHOWN.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, NotificationBadgeShownLabel> notification_badge_shown(6035);

  /**
   * generated from update.notification_dismissed
   */
  enum class NotificationDismissedLabel: uint16_t {
    eRestart = 0,
    eAvailable = 1,
    eManual = 2,
    eUnsupported = 3,
    eOtherinstance = 4,
    e__Other__,
  };
  /**
   * Update: the dismiss action was executed for this application update doorhanger type.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_NOTIFICATION_DISMISSED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, NotificationDismissedLabel> notification_dismissed(6036);

  /**
   * generated from update.notification_main_action_doorhanger
   */
  enum class NotificationMainActionDoorhangerLabel: uint16_t {
    eRestart = 0,
    eAvailable = 1,
    eManual = 2,
    eUnsupported = 3,
    eOtherinstance = 4,
    e__Other__,
  };
  /**
   * Update: the main update action was initiated for this application update doorhanger type.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_NOTIFICATION_MAIN_ACTION_DOORHANGER.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, NotificationMainActionDoorhangerLabel> notification_main_action_doorhanger(6037);

  /**
   * generated from update.notification_main_action_menu
   */
  enum class NotificationMainActionMenuLabel: uint16_t {
    eRestart = 0,
    eAvailable = 1,
    eManual = 2,
    eUnsupported = 3,
    eOtherinstance = 4,
    e__Other__,
  };
  /**
   * Update: the update action was initiated from the PanelUI application update menu item.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_NOTIFICATION_MAIN_ACTION_MENU.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, NotificationMainActionMenuLabel> notification_main_action_menu(6038);

  /**
   * generated from update.notification_shown
   */
  enum class NotificationShownLabel: uint16_t {
    eRestart = 0,
    eAvailable = 1,
    eManual = 2,
    eUnsupported = 3,
    eOtherinstance = 4,
    e__Other__,
  };
  /**
   * Update: the application update doorhanger type that was displayed.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram UPDATE_NOTIFICATION_SHOWN.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, NotificationShownLabel> notification_shown(6039);

  /**
   * generated from update.ping_count_external
   * Update: count of systems for this ping for comparison with other pings (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_PING_COUNT_EXTERNAL.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ping_count_external(6040);

  /**
   * generated from update.ping_count_notify
   * Update: count of systems for this ping for comparison with other pings (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_PING_COUNT_NOTIFY.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ping_count_notify(6041);

  /**
   * generated from update.ping_count_subsequent
   * Update: count of systems for this ping for comparison with other pings (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_PING_COUNT_SUBSEQUENT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ping_count_subsequent(6042);

  /**
   * generated from update.pref_service_errors_external
   * Update: number of sequential update service errors greater than 0 (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_SERVICE_ERRORS_EXTERNAL.
   */
  constexpr impl::CustomDistributionMetric pref_service_errors_external(6043);

  /**
   * generated from update.pref_service_errors_notify
   * Update: number of sequential update service errors greater than 0 (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_SERVICE_ERRORS_NOTIFY.
   */
  constexpr impl::CustomDistributionMetric pref_service_errors_notify(6044);

  /**
   * generated from update.pref_service_errors_subsequent
   * Update: number of sequential update service errors greater than 0 (after we already have an update ready)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_SERVICE_ERRORS_SUBSEQUENT.
   */
  constexpr impl::CustomDistributionMetric pref_service_errors_subsequent(6045);

  /**
   * generated from update.pref_update_cancelations_external
   * Update: number of sequential update elevation request cancelations greater than 0 (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_UPDATE_CANCELATIONS_EXTERNAL.
   */
  constexpr impl::CustomDistributionMetric pref_update_cancelations_external(6046);

  /**
   * generated from update.pref_update_cancelations_notify
   * Update: number of sequential update elevation request cancelations greater than 0 (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_UPDATE_CANCELATIONS_NOTIFY.
   */
  constexpr impl::CustomDistributionMetric pref_update_cancelations_notify(6047);

  /**
   * generated from update.pref_update_cancelations_subsequent
   * Update: number of sequential update elevation request cancelations greater than 0 (after we already have an update ready)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_PREF_UPDATE_CANCELATIONS_SUBSEQUENT.
   */
  constexpr impl::CustomDistributionMetric pref_update_cancelations_subsequent(6048);

  /**
   * generated from update.previous_build_id
   * The Firefox build id the browser is updating from.
   * Follows the same format as application.buildId.
   * Only valid for "update" pings with reason "success".
   */
  constexpr impl::StringMetric previous_build_id(6049);

  /**
   * generated from update.previous_channel
   * The Firefox channel the profile was on before the update was applied.
   * Only valid for "update" pings with reason "success".
   */
  constexpr impl::StringMetric previous_channel(6050);

  /**
   * generated from update.previous_version
   * The Firefox version the browser is updating from.
   * Follows the same format as application.version.
   * Only valid for "update" pings with reason "success".
   */
  constexpr impl::StringMetric previous_version(6051);

  /**
   * generated from update.service_installed_external
   */
  enum class ServiceInstalledExternalLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Update: whether the service is installed (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram UPDATE_SERVICE_INSTALLED_EXTERNAL.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ServiceInstalledExternalLabel> service_installed_external(6052);

  /**
   * generated from update.service_installed_notify
   */
  enum class ServiceInstalledNotifyLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Update: whether the service is installed (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram UPDATE_SERVICE_INSTALLED_NOTIFY.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ServiceInstalledNotifyLabel> service_installed_notify(6053);

  /**
   * generated from update.service_installed_subsequent
   */
  enum class ServiceInstalledSubsequentLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Update: whether the service is installed (after we already have an update ready)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram UPDATE_SERVICE_INSTALLED_SUBSEQUENT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ServiceInstalledSubsequentLabel> service_installed_subsequent(6054);

  /**
   * generated from update.service_manually_uninstalled_external
   * Update: count of systems that manually uninstalled the service (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_SERVICE_MANUALLY_UNINSTALLED_EXTERNAL.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> service_manually_uninstalled_external(6055);

  /**
   * generated from update.service_manually_uninstalled_notify
   * Update: count of systems that manually uninstalled the service (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_SERVICE_MANUALLY_UNINSTALLED_NOTIFY.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> service_manually_uninstalled_notify(6056);

  /**
   * generated from update.service_manually_uninstalled_subsequent
   * Update: count of systems that manually uninstalled the service (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_SERVICE_MANUALLY_UNINSTALLED_SUBSEQUENT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> service_manually_uninstalled_subsequent(6057);

  /**
   * generated from update.state_code_complete_stage
   * Update: the state of a complete patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_COMPLETE_STAGE.
   */
  constexpr impl::CustomDistributionMetric state_code_complete_stage(6058);

  /**
   * generated from update.state_code_complete_startup
   * Update: the state of a complete update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_COMPLETE_STARTUP.
   */
  constexpr impl::CustomDistributionMetric state_code_complete_startup(6059);

  /**
   * generated from update.state_code_partial_stage
   * Update: the state of a partial patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_PARTIAL_STAGE.
   */
  constexpr impl::CustomDistributionMetric state_code_partial_stage(6060);

  /**
   * generated from update.state_code_partial_startup
   * Update: the state of a partial patch update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_PARTIAL_STARTUP.
   */
  constexpr impl::CustomDistributionMetric state_code_partial_startup(6061);

  /**
   * generated from update.state_code_unknown_stage
   * Update: the state of an unknown patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_UNKNOWN_STAGE.
   */
  constexpr impl::CustomDistributionMetric state_code_unknown_stage(6062);

  /**
   * generated from update.state_code_unknown_startup
   * Update: the state of an unknown patch update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATE_CODE_UNKNOWN_STARTUP.
   */
  constexpr impl::CustomDistributionMetric state_code_unknown_startup(6063);

  /**
   * generated from update.state_write_failure
   * Update: Count of the number of times we have shown a notification to the user that they need to manually update because we cannot write to the update status file.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> state_write_failure(6064);

  /**
   * generated from update.status_error_code_complete_stage
   * Update: the status error code for a failed complete patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_COMPLETE_STAGE.
   */
  constexpr impl::CustomDistributionMetric status_error_code_complete_stage(6065);

  /**
   * generated from update.status_error_code_complete_startup
   * Update: the status error code for a failed complete patch update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_COMPLETE_STARTUP.
   */
  constexpr impl::CustomDistributionMetric status_error_code_complete_startup(6066);

  /**
   * generated from update.status_error_code_partial_stage
   * Update: the status error code for a failed partial patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_PARTIAL_STAGE.
   */
  constexpr impl::CustomDistributionMetric status_error_code_partial_stage(6067);

  /**
   * generated from update.status_error_code_partial_startup
   * Update: the status error code for a failed partial patch update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_PARTIAL_STARTUP.
   */
  constexpr impl::CustomDistributionMetric status_error_code_partial_startup(6068);

  /**
   * generated from update.status_error_code_unknown_stage
   * Update: the status error code for a failed unknown patch update from update.status after staging
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_UNKNOWN_STAGE.
   */
  constexpr impl::CustomDistributionMetric status_error_code_unknown_stage(6069);

  /**
   * generated from update.status_error_code_unknown_startup
   * Update: the status error code for a failed unknown patch update from update.status on startup
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram UPDATE_STATUS_ERROR_CODE_UNKNOWN_STARTUP.
   */
  constexpr impl::CustomDistributionMetric status_error_code_unknown_startup(6070);

  /**
   * generated from update.target_build_id
   * The Firefox build id the browser is updating to.
   * Follows the same format as application.buildId.
   * Only valid for "update" pings with reason "ready".
   */
  constexpr impl::StringMetric target_build_id(6071);

  /**
   * generated from update.target_channel
   * The Firefox channel the update was fetched from.
   * Only valid for "update" pings with reason "ready".
   */
  constexpr impl::StringMetric target_channel(6072);

  /**
   * generated from update.target_display_version
   * The Firefox display version the browser is updating to.
   * This may contain a different value than `update.target_version`,
   * e.g. for the Beta channel this field will report the beta suffix
   * while `update.target_version` will only report the version number.
   * Only valid for "update" pings with reason "ready".
   */
  constexpr impl::StringMetric target_display_version(6073);

  /**
   * generated from update.target_version
   * The Firefox version the browser is updating to.
   * Follows the same format as application.version.
   * Only valid for "update" pings with reason "ready".
   */
  constexpr impl::StringMetric target_version(6074);

  /**
   * generated from update.unable_to_apply_external
   * Update: count of systems that cannot apply updates (externally initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_UNABLE_TO_APPLY_EXTERNAL.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> unable_to_apply_external(6075);

  /**
   * generated from update.unable_to_apply_notify
   * Update: count of systems that cannot apply updates (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_UNABLE_TO_APPLY_NOTIFY.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> unable_to_apply_notify(6076);

  /**
   * generated from update.unable_to_apply_subsequent
   * Update: count of systems that cannot apply updates (timer initiated)
   * This metric was generated to correspond to the Legacy Telemetry count histogram UPDATE_UNABLE_TO_APPLY_SUBSEQUENT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> unable_to_apply_subsequent(6077);
}

namespace update_settings {
  /**
   * generated from update.settings.auto_download
   * Whether app updates are set to auto-download.
   */
  constexpr impl::BooleanMetric auto_download(6083);

  /**
   * generated from update.settings.background
   * Whether updates can be delivered in the background.
   */
  constexpr impl::BooleanMetric background(6084);

  /**
   * generated from update.settings.channel
   * The update channel according to defaults,
   * including partner bits.
   * e.g. "nightly-cck"
   */
  constexpr impl::StringMetric channel(6085);

  /**
   * generated from update.settings.enabled
   * Whether updates are available.
   */
  constexpr impl::BooleanMetric enabled(6086);
}

namespace updater {
  /**
   * generated from updater.available
   * Whether the app was built with the updater binary.
   * Corresponds to the value of the `MOZ_UPDATER` define.
   */
  constexpr impl::BooleanMetric available(6087);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitMozappsUpdateMetrics_h
